/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.library.modifier.hooks;

import com.hoshino.cti.library.modifier.CtiModifierHook;
import java.util.Collection;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public interface SlotStackModifierHook {
    default public boolean overrideStackedOnOther(IToolStackView heldTool, ModifierEntry modifier, Slot slot, Player player) {
        return false;
    }

    default public boolean overrideOtherStackedOnMe(IToolStackView slotTool, ModifierEntry modifier, ItemStack held, Slot slot, Player player, SlotAccess access) {
        return false;
    }

    public static boolean handleSlotStackOnMe(ItemStack slotStack, ItemStack held, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (slotStack.m_41720_() instanceof IModifiable && action == ClickAction.SECONDARY && slotStack.m_41613_() == 1 && slot.m_150651_(player)) {
            ToolStack tool = ToolStack.from((ItemStack)slotStack);
            for (ModifierEntry entry : tool.getModifierList()) {
                if (!((SlotStackModifierHook)entry.getHook(CtiModifierHook.SLOT_STACK)).overrideOtherStackedOnMe((IToolStackView)tool, entry, held, slot, player, access)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean handleSlotStackOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (stack.m_41720_() instanceof IModifiable && action == ClickAction.SECONDARY && stack.m_41613_() == 1 && slot.m_150651_(player)) {
            ToolStack tool = ToolStack.from((ItemStack)stack);
            for (ModifierEntry entry : tool.getModifierList()) {
                if (!((SlotStackModifierHook)entry.getHook(CtiModifierHook.SLOT_STACK)).overrideStackedOnOther((IToolStackView)tool, entry, slot, player)) continue;
                return true;
            }
        }
        return false;
    }

    public record FirstMerger(Collection<SlotStackModifierHook> modules) implements SlotStackModifierHook
    {
        @Override
        public boolean overrideStackedOnOther(IToolStackView heldTool, ModifierEntry modifier, Slot slot, Player player) {
            for (SlotStackModifierHook module : this.modules) {
                if (!module.overrideStackedOnOther(heldTool, modifier, slot, player)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean overrideOtherStackedOnMe(IToolStackView slotTool, ModifierEntry modifier, ItemStack held, Slot slot, Player player, SlotAccess access) {
            for (SlotStackModifierHook module : this.modules) {
                if (!module.overrideOtherStackedOnMe(slotTool, modifier, held, slot, player, access)) continue;
                return true;
            }
            return false;
        }
    }
}

